AddCSLuaFile("cl_init.lua")
AddCSLuaFile("shared.lua")
include('shared.lua')

function ENT:SpawnFunction(ply, tr)
	if (!tr.Hit) then return end
	local SpawnPos = tr.HitPos + tr.HitNormal * 35
	self.Spawn_angles = ply:GetAngles()
	self.Spawn_angles.pitch = 0
	self.Spawn_angles.roll = 0
	self.Spawn_angles.yaw = self.Spawn_angles.yaw
	local ent = ents.Create(self.EntName)
	ent:SetPos(SpawnPos)
	ent:SetAngles(self.Spawn_angles)
	ent:Spawn()
	ent:Activate()
	return ent
end

function ENT:Initialize()
	self:SetModel(self.model)
	self:SetMoveType(MOVETYPE_NONE)
	self:SetSolid(SOLID_NONE)
	self:SetAngles(Angle(0,0,0))
	self:DrawShadow(true)
	self:DropToFloor()
	self.Available = true
	self:SetCollisionGroup(COLLISION_GROUP_WORLD)
	self:SetRenderMode(RENDERMODE_TRANSALPHA)
end

function ENT:Think()
	if self.ReEnabled and CurTime() >= self.ReEnabled then
		self.ReEnabled = nil
		self.Available = true
		self:SetNoDraw(false)
	end
	for k,v in pairs (player.GetAll()) do
		if v:GetPos():Distance(self:GetPos()) < 60 and self.Available == true and v:Alive() then
			local ammoCount = v:GetAmmoCount(self.AmmoType)
			self.Available = false
			self:SetNoDraw(true)
			self.ReEnabled = CurTime() + 30
			v:EmitSound("world/w_pkup.wav", 85, math.random(95,105))
			v:Give(self.WeapName)
			if (ammoCount < self.MaxAmmo) then
				v:SetAmmo(math.min(ammoCount + self.AmmoAmount, self.MaxAmmo), self.AmmoType)
			end
		end
	end
end